<?php
$totalCursosAfiliado = ControladorFiliado::ctrMostrarQuantoCursoSouAfiliadoPorIdUsuario($_SESSION['ID_usuario']);
?>
<section class="">
    <h2 class="section-title">Estatistica de Afiliado</h2>

    <div class="activities-container mt-25 p-20 p-lg-35">
        <div class="row">

            <div class="col-4 d-flex align-items-center justify-content-center">
                <div class="d-flex flex-column align-items-center text-center">
                    <img src="estudante/Affiliate Marketing _ Rocket LMS_files/48.svg" width="64" height="64" alt="">
                    <strong class="font-30 text-dark-blue font-weight-bold mt-5"><?php echo $totalCursosAfiliado; ?></strong>
                    <span class="font-16 text-gray font-weight-500">Cursos Afiliado</span>
                </div>
            </div>

            <div class="col-4 d-flex align-items-center justify-content-center">
                <div class="d-flex flex-column align-items-center text-center">
                    <img src="estudante/Affiliate Marketing _ Rocket LMS_files/38.svg" width="64" height="64" alt="">
                    <strong class="font-30 text-dark-blue font-weight-bold mt-5">0,00 Akz</strong>
                    <span class="font-16 text-gray font-weight-500">Bonus</span>
                </div>
            </div>

            <div class="col-4 d-flex align-items-center justify-content-center">
                <div class="d-flex flex-column align-items-center text-center">
                    <img src="estudante/Affiliate Marketing _ Rocket LMS_files/36.svg" width="64" height="64" alt="">
                    <strong class="font-30 text-dark-blue font-weight-bold mt-5">0,00 Akz</strong>
                    <span class="font-16 text-gray font-weight-500">Comissão</span>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="mt-25">
    
    <div class="row mt-15">
        <div class="col-12 col-lg-5">
            <h3 class="font-16 font-weight-500">Link de Afiliado</h3>

            <div class="form-group mt-5">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <button type="button" class="input-group-text js-copy" data-input="affiliate_url" data-toggle="tooltip" data-placement="top" title="" data-copy-text="Copy" data-done-text="Done" data-original-title="Copy">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-copy text-white"><rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect><path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1"></path></svg>
                        </button>
                    </div>
                    <input type="text" name="affiliate_url" readonly="" value="Você não tem um link" class="form-control">
                </div>
            </div>
        </div>
    </div>

</section>

<section class="mt-25">
    <h2 class="section-title">Cursos em que a organização esta Afiliada</h2>

    <div class="panel-section-card py-20 px-25 mt-20">
        <div class="row">
            <div class="col-12 ">
                <div class="table-responsive">
                    <?php
                    echo"
                    <table class='table text-center custom-table'>
                        <thead>
                        <tr>
                            <th>Curso</th>
                            <th class='text-center'>Preço de Venda</th>
                            <th class='text-center'>Comissão</th>
                            <th class='text-center'>Data aquisição</th>
                            <th class='text-center'>Link</th>
                        </tr>
                        </thead>
                        <tbody>";
                        
                        $filido = ControladorFiliado::ctrMostrarVagasQueUsuarioEstaFiliadoPorIdUsuario($_SESSION['ID_usuario']);
                        foreach ($filido as $key => $valorFiliado) {
                        $dadosVagaFiliado = ControladorVagaFiliado::ctrMostrarVagaFiliadoPoridVaga($valorFiliado['idVaga']);
                        $vagas = ControladorVaga::ctrMostrarVagaPoridVaga($valorFiliado['idVaga']);
                        foreach ($vagas as $indice => $infoVagas) {
                            $valor = 0;
                            echo"
                            <tr>
                                <td class='text-left'>
                                    <div class='user-inline-avatar d-flex align-items-center'>
                                        <div class=' ml-5'> 
                                            <span class='d-block font-weight-500'><a href='estudante.php?pq=VendaAfiliado&vdsF=".$valorFiliado["idFiliado"]."'>".$infoVagas["vaga"]."</a></span>
                                        </div>
                                    </div>
                                </td>

                                <td>" .number_format($dadosVagaFiliado[0]["preco"],2,",","."). " Kz</td>

                                <td>" .number_format($dadosVagaFiliado[0]["valorGanhoPorCadaVendaFiliado"],2,",","."). " Kz</td>

                                <td>".$dadosVagaFiliado[0]["dataCadastro"]."</td>
                                <td>.www.smartschool.ao?vcf=".$valorFiliado["idFiliado"]. "
                            </tr>";
                        }
                    }
                            ?>
                        </tbody>
                    </table>
                </div>

                <div class="my-30">
                    
                </div>
            </div>
        </div>
    </div>
</section>